---
name: Bug report
about: Tell us about realgud bugs

---

<!--

Bugs are not for asking questions about how to use or install realgud.

For that use some question and answer venue like
https://emacs.stackexchange.com/ .

For these kinds of things, you will save yourself time by asking
instead on forums like `Emacs StackExchange
<https://emacs.stackexchange.com/>`_ that is geared to helping people
for such general or novice kinds questions and tasks. And unless you
are a sponsor of the project, if your question seems to be of this
category, the issue may just be closed.

Also, the unless you are a sponsor of the project, it may take a
while, maybe a week or so, before the bug report is noticed, let alone
acted upon.

To set expectations, some legitimate bugs can take years to fix, but
many eventually do get fixed, depending on difficulty, availability of
help, or funding level.

Funding the project was added to partially address the problem that there are
lots of people seeking help and reporting bugs, but few people who are
willing or capable of providing help or fixing bugs.

Tasks or the kinds of things others can do, but you can't do or don't
want to do yourself are typically the kind of thing that you pay
someone to do, especially when you are the primary beneficiary of the
work, or the task is complex, long, or tedious.
-->

<!--
Please remove any of the optional sections if they are not applicable.
-->

## Description

<!-- Please add a clear and concise description of the bug. Try to narrow the problem down to the smallest that exhibits the bug.-->

## How to Reproduce

<!-- Please show both the *input* you gave and the
output you got in describing how to reproduce the bug:

or give a complete console log with input and output

-->

## Output Given

<!--
Please include not just the error message but all output leading to the message which includes echoing input and messages up to the error.
For a command-line environment include command invocation and all the output produced.

If this is too long, then try narrowing the problem to something short.
-->


## Expected behavior

<!-- Add a clear and concise description of what you expected to happen. -->

## Environment

<!-- _This section sometimes is optional but helpful to us._

Please modify for your setup

- realgud version:
- debugger(s) used
- OS and Version: [e.g. Ubuntu bionic]

-->

## What you have tried to solve the problem

<!--

If you have tried to solve the problem on your own, please describe what steps you took or what you look up.

If you haven't tried to solve the problem on your own, you should try to do so.
-->



## Workarounds

<!-- If there is a workaround for the problem, describe that here. -->

## Priority

<!-- If this is important for a particular public good state that here.
     If this is blocking some important activity let us know what activity it blocks.

	 Otherwise, we'll assume this has the lowest priority in addressing.
	 -->

## Additional Context

<!-- _This section is optional._

Add any other context about the problem here or special environment setup.

-->
