;;; ef-melissa-light-theme.el --- Legible light theme with warm colors (yellow, red, green, cyan) -*- lexical-binding:t -*-

;; Copyright (C) 2022-2024  Free Software Foundation, Inc.

;; Author: Protesilaos Stavrou <info@protesilaos.com>
;; Maintainer: Protesilaos Stavrou <info@protesilaos.com>
;; URL: https://github.com/protesilaos/ef-themes
;; Keywords: faces, theme, accessibility

;; This file is NOT part of GNU Emacs.

;; GNU Emacs is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs.  If not, see <https://www.gnu.org/licenses/>.

;;; Commentary:
;;
;; The `ef-themes' are a collection of light and dark themes for GNU
;; Emacs whose goal is to provide colorful ("pretty") yet legible
;; options for users who want something with a bit more flair than the
;; `modus-themes' (also designed by me).

;;; Code:



(require 'ef-themes)

(defconst ef-melissa-light-palette-partial
  '((cursor "#a07f00")
    (bg-main "#fff6d8")
    (bg-dim "#f5e9cb")
    (bg-alt "#e7d7c6")
    (fg-main "#484431")
    (fg-dim "#68708a")
    (fg-alt "#80431a")
    (bg-active "#c7b7a6")
    (bg-inactive "#f9efd4")
    (border "#c5baa6")

    (red "#ba2d2f")
    (red-warmer "#c74400")
    (red-cooler "#c02945")
    (red-faint "#b05350")
    (green "#007a0a")
    (green-warmer "#5a7400")
    (green-cooler "#008250")
    (green-faint "#61756c")
    (yellow "#a26310")
    (yellow-warmer "#ba5205")
    (yellow-cooler "#946830")
    (yellow-faint "#7f6f1a")
    (blue "#375cc6")
    (blue-warmer "#5f5fdf")
    (blue-cooler "#265fbf")
    (blue-faint "#4a659f")
    (magenta "#aa3e74")
    (magenta-warmer "#b02f80")
    (magenta-cooler "#6448ca")
    (magenta-faint "#905ea0")
    (cyan "#3f60af")
    (cyan-warmer "#4060a0")
    (cyan-cooler "#0f708a")
    (cyan-faint "#4f6f8f")

    (bg-red-intense "#ff8f88")
    (bg-green-intense "#96df80")
    (bg-yellow-intense "#efbf00")
    (bg-blue-intense "#cfceff")
    (bg-magenta-intense "#df9fff")
    (bg-cyan-intense "#88cfd0")

    (bg-red-subtle "#ffceb0")
    (bg-green-subtle "#cbf09f")
    (bg-yellow-subtle "#f4ed7e")
    (bg-blue-subtle "#cce4f2")
    (bg-magenta-subtle "#fad6ef")
    (bg-cyan-subtle "#bfefef")

    (bg-added "#d7ecb0")
    (bg-added-faint "#eef3c2")
    (bg-added-refine "#c9dda0")
    (fg-added "#005000")

    (bg-changed "#f5e690")
    (bg-changed-faint "#f5edaf")
    (bg-changed-refine "#edd482")
    (fg-changed "#553d00")

    (bg-removed "#f8d0b6")
    (bg-removed-faint "#f5deb0")
    (bg-removed-refine "#f0bba9")
    (fg-removed "#8f1313")

    (bg-mode-line-active "#f3cf72")
    (fg-mode-line-active "#403328")
    (bg-completion "#ffe2a8")
    (bg-hover "#deb4f0")
    (bg-hover-secondary "#c4d47a")
    (bg-hl-line "#fae7b0")
    (bg-paren-match "#afcf8f")
    (bg-region "#f0d4d8")
    (bg-err "#ffd4b5") ; check with err
    (bg-warning "#ffe89f") ; check with warning
    (bg-info "#ddf5ac") ; check with info

    (err red-warmer)
    (warning yellow-warmer)
    (info green)

    (fg-link yellow)
    (fg-link-alt magenta-cooler)
    (name yellow-cooler)
    (keybind yellow-warmer)
    (identifier red-faint)
    (prompt green-warmer)

    (builtin yellow-cooler)
    (comment yellow-faint)
    (constant cyan)
    (fnname green-warmer)
    (fnname-call green-faint)
    (keyword yellow)
    (preprocessor yellow-warmer)
    (docstring red-faint)
    (string red-warmer)
    (type green-cooler)
    (variable cyan-cooler)
    (variable-use cyan-faint)
    (rx-escape green) ; compare with `string'
    (rx-construct magenta-cooler)

    (accent-0 yellow-warmer)
    (accent-1 green-cooler)
    (accent-2 red)
    (accent-3 magenta-cooler)

    (date-common green-warmer)
    (date-deadline red)
    (date-deadline-subtle red-faint)
    (date-event fg-alt)
    (date-holiday magenta-warmer)
    (date-now fg-main)
    (date-range fg-alt)
    (date-scheduled yellow)
    (date-scheduled-subtle yellow-faint)
    (date-weekday green-warmer)
    (date-weekend red-faint)

    (prose-code yellow-warmer)
    (prose-done green)
    (prose-macro green-warmer)
    (prose-metadata fg-dim)
    (prose-metadata-value fg-alt)
    (prose-table fg-alt)
    (prose-table-formula warning)
    (prose-tag yellow-faint)
    (prose-todo red-warmer)
    (prose-verbatim red)

    (mail-cite-0 yellow-warmer)
    (mail-cite-1 cyan-warmer)
    (mail-cite-2 red-cooler)
    (mail-cite-3 green-cooler)
    (mail-part cyan-cooler)
    (mail-recipient yellow)
    (mail-subject green-warmer)
    (mail-other yellow-cooler)

    (bg-search-static bg-warning)
    (bg-search-current bg-yellow-intense)
    (bg-search-lazy bg-blue-intense)
    (bg-search-replace bg-red-intense)

    (bg-search-rx-group-0 bg-magenta-intense)
    (bg-search-rx-group-1 bg-green-intense)
    (bg-search-rx-group-2 bg-red-subtle)
    (bg-search-rx-group-3 bg-cyan-subtle)

    (bg-space-err bg-yellow-intense)

    (rainbow-0 yellow-warmer)
    (rainbow-1 yellow)
    (rainbow-2 green-warmer)
    (rainbow-3 red-cooler)
    (rainbow-4 cyan-warmer)
    (rainbow-5 magenta)
    (rainbow-6 green-cooler)
    (rainbow-7 magenta-warmer)
    (rainbow-8 cyan-cooler))
  "Legible light honeybee theme with warm colors (yellow, red, green, cyan).")

(defcustom ef-melissa-light-palette-overrides nil
  "Overrides for `ef-melissa-light-palette'.

Mirror the elements of the aforementioned palette, overriding
their value.

For overrides that are shared across all of the Ef themes,
refer to `ef-themes-common-palette-overrides'.

To preview the palette entries, use `ef-themes-preview-colors' or
`ef-themes-preview-colors-current' (read the documentation for
further details)."
  :group 'ef-themes
  :package-version '(ef-themes . "1.0.0")
  :type '(repeat (list symbol (choice symbol string)))
  :link '(info-link "(ef-themes) Palette overrides"))

(defconst ef-melissa-light-palette
  (append ef-themes-common-palette-overrides ef-melissa-light-palette-partial ef-themes-palette-common))

(modus-themes-theme
 'ef-melissa-light
 'ef-themes
 "Legible light honeybee theme with warm colors (yellow, red, green, cyan)."
 'light
 'modus-operandi-palette
 'ef-melissa-light-palette
 'ef-melissa-light-palette-overrides
 'ef-themes-custom-faces)

;;; ef-melissa-light-theme.el ends here
